/*
* Creation date :
* Last modified :
*/
/** @file
* \brief This file contains implementation of 
* test functions for RSA cryptography
* which worked with LibTomCrypt.
*
* \version CE2_RSA_TST_2.c#1:csrc:1
* \author Ihar Yermalayeu
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Include Files ***********************/

#include "CE2_TST_RSA_2.h"
#include "memory.h"

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Global Data *************************/
/************************ Private Functions *******************/
/************************ Public Functions ********************/

/***************************************************************
* Function Name: 
*  CE2_TST_RSA_SHEME_EncDec_01
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  Additional test for RSA_SHEME_EncDec.
*
* \b
* Algorithm:
***************************************************************/
CE2Error_t CE2_TST_RSA_SHEME_EncDec_01(FILE *out)
{
  CE2Error_t test_result = 0, error = CE2_OK;
  DxUint8_t publExp[] = {0x01,0x00,0x01};
  CE2_RSAUserPrivKey_t privKey;
  CE2_RSAUserPubKey_t publKey;
  DxUint8_t L[1] = {0x00};
  DxUint8_t testMessage[] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08};
  DxUint8_t cryptMessage[1024];
  DxUint8_t planMessage[1024];
  DxUint16_t planMessageSize = 8;

  PrintTestBeginMsg(out, __FUNCTION__);

  error = CE2_RSA_KG_GenerateKeyPair(publExp, 3, 512, &privKey, &publKey);
  if (error != CE2_OK) {
    fprintf(out, "Can't generate RSA key Pair!");
    test_result |= error;
    goto test_end;
  }

  //error = _DX_RSA_SCHEMES_Encrypt(&publKey, CE2_RSA_HASH_SHA1_mode,
  //  L, 0, CE2_PKCS1_MGF1, testMessage, 7, cryptMessage, CE2_PKCS1_VER21);
  //if (error != CE2_OK)
  //{
  //  fprintf(out, "Can't make SCHEMES encryption!");
  //  test_result |= error;
  //  goto test_end;
  //}

  //error = _DX_RSA_SCHEMES_Encrypt(&publKey, CE2_RSA_HASH_NO_HASH_mode, L, 0, 
  //  CE2_PKCS1_NO_MGF, testMessage, 7, cryptMessage, CE2_PKCS1_VER15);
  error = CE2_RSA_PKCS1v15_Encrypt(&publKey, testMessage, planMessageSize, cryptMessage);
  if (error != CE2_OK)
  {
    fprintf(out, "Can't make SCHEMES encryption!\n");
    test_result |= error;
    goto test_end;
  }

  //error = _DX_RSA_SCHEMES_Decrypt(&privKey, CE2_RSA_HASH_NO_HASH_mode, L, 0, 
  //  CE2_PKCS1_NO_MGF, cryptMessage, 64, planMessage, &planMessageSize, CE2_PKCS1_VER15);
  error = CE2_RSA_PKCS1v15_Decrypt(&privKey, cryptMessage, 64, planMessage, &planMessageSize);
  if (error != CE2_OK)
  {
    fprintf(out, "Can't make SCHEMES decryption!\n");
    test_result |= error;
    goto test_end;
  }

  error = memcmp(testMessage, planMessage, sizeof(testMessage));
  if (error != CE2_OK)
  {
    fprintf(out, "Wrong data after RSA SCHEMES encryption/decryption!");
		PrintBuffer(out, testMessage, sizeof(testMessage), "plan test");
		PrintBuffer(out, planMessage, planMessageSize, "plan out");
    test_result |= error;
    goto test_end;
  }



test_end:
  PrintTestEndMsg(out, __FUNCTION__, test_result);

  return test_result;
} /* End of CE2_TST_RSA_SHEME_EncDec_01 */

/***************************************************************
* Function Name: 
*  CE2_TST_RSA_SHEME_SignVerify_01
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  Additional test for RSA_SHEME_EncDec.
*
* \b
* Algorithm:
***************************************************************/
CE2Error_t CE2_TST_RSA_SHEME_SignVerify_ZeroMessage_01(FILE *out)
{
  CE2Error_t test_result = 0, error = CE2_OK;
  DxUint8_t publExp[] = {0x01,0x00,0x01};
  CE2_RSAUserPrivKey_t privKey;
  CE2_RSAUserPubKey_t publKey;
  DxUint8_t L[1] = {0x00};
  DxUint8_t sign[2048];
  DxUint16_t signSize = sizeof(sign);

  PrintTestBeginMsg(out, __FUNCTION__);

  error = CE2_RSA_KG_GenerateKeyPair(publExp, 3, 512, &privKey, &publKey);
  if (error != CE2_OK) {
    fprintf(out, "Can't generate RSA key Pair!");
    test_result |= error;
    goto test_end;
  }

  error = CE2_RSA_PKCS1v15_Sign(&privKey, CE2_RSA_HASH_SHA1_mode, 
    0, 0, sign, &signSize);
  if (error != CE2_OK)
  {
    fprintf(out, "Can't sign zero message (PKCS1v15)!\n");
    test_result |= error;
    goto test_end;
  }

  error = CE2_RSA_PKCS1v15_Verify(&publKey, CE2_RSA_HASH_SHA1_mode,
    0, 0, sign);
  if (error != CE2_OK)
  {
    fprintf(out, "Can't verify zero message (PKCS1v15)!\n");
    test_result |= error;
    goto test_end;
  }

test_end:
  PrintTestEndMsg(out, __FUNCTION__, test_result);

  return test_result;
} /* End of CE2_TST_RSA_SHEME_SignVerify_01 */
